/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NoiseControlOff: ImageVector
    get() {
        if (_noiseControlOff != null) {
            return _noiseControlOff!!
        }
        _noiseControlOff = materialIcon(name = "Filled.NoiseControlOff") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveToRelative(1.44f, 0.0f, 2.79f, 0.38f, 3.95f, 1.05f)
                lineToRelative(1.45f, -1.45f)
                curveTo(15.85f, 2.59f, 13.99f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(8.15f, 2.59f, 6.59f, 3.59f)
                lineToRelative(1.45f, 1.45f)
                curveTo(9.21f, 4.38f, 10.56f, 4.0f, 12.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, 1.44f, -0.38f, 2.79f, -1.05f, 3.95f)
                lineToRelative(1.45f, 1.45f)
                curveTo(21.41f, 15.85f, 22.0f, 13.99f, 22.0f, 12.0f)
                reflectiveCurveToRelative(-0.59f, -3.85f, -1.59f, -5.41f)
                lineToRelative(-1.45f, 1.45f)
                curveTo(19.62f, 9.21f, 20.0f, 10.56f, 20.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 20.0f)
                curveToRelative(-1.44f, 0.0f, -2.79f, -0.38f, -3.95f, -1.05f)
                lineToRelative(-1.45f, 1.45f)
                curveTo(8.15f, 21.41f, 10.01f, 22.0f, 12.0f, 22.0f)
                reflectiveCurveToRelative(3.85f, -0.59f, 5.41f, -1.59f)
                lineToRelative(-1.45f, -1.45f)
                curveTo(14.79f, 19.62f, 13.44f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 12.0f)
                curveToRelative(0.0f, -1.44f, 0.38f, -2.79f, 1.05f, -3.95f)
                lineTo(3.59f, 6.59f)
                curveTo(2.59f, 8.15f, 2.0f, 10.01f, 2.0f, 12.0f)
                reflectiveCurveToRelative(0.59f, 3.85f, 1.59f, 5.41f)
                lineToRelative(1.45f, -1.45f)
                curveTo(4.38f, 14.79f, 4.0f, 13.44f, 4.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(11.5f, 6.0f)
                curveTo(9.02f, 6.0f, 7.0f, 8.02f, 7.0f, 10.5f)
                curveToRelative(0.0f, 1.22f, 0.49f, 2.41f, 1.35f, 3.27f)
                lineToRelative(1.36f, 1.36f)
                curveToRelative(0.17f, 0.17f, 0.31f, 0.44f, 0.44f, 0.82f)
                curveTo(10.56f, 17.17f, 11.71f, 18.0f, 13.0f, 18.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, -1.35f, 3.0f, -3.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                curveToRelative(-0.43f, 0.0f, -0.81f, -0.27f, -0.95f, -0.68f)
                curveToRelative(-0.15f, -0.44f, -0.4f, -1.08f, -0.93f, -1.61f)
                lineToRelative(-1.36f, -1.36f)
                curveTo(9.28f, 11.87f, 9.0f, 11.19f, 9.0f, 10.5f)
                curveTo(9.0f, 9.12f, 10.12f, 8.0f, 11.5f, 8.0f)
                curveToRelative(1.21f, 0.0f, 2.22f, 0.86f, 2.45f, 2.0f)
                horizontalLineToRelative(2.02f)
                curveTo(15.72f, 7.75f, 13.81f, 6.0f, 11.5f, 6.0f)
                close()
            }
            materialPath {
                moveTo(13.5f, 12.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _noiseControlOff!!
    }

private var _noiseControlOff: ImageVector? = null
