/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PanoramaVerticalSelect: ImageVector
    get() {
        if (_panoramaVerticalSelect != null) {
            return _panoramaVerticalSelect!!
        }
        _panoramaVerticalSelect = materialIcon(name = "Filled.PanoramaVerticalSelect") {
            materialPath {
                moveTo(19.93f, 21.12f)
                curveToRelative(-1.1f, -2.94f, -1.64f, -6.03f, -1.64f, -9.12f)
                reflectiveCurveToRelative(0.55f, -6.18f, 1.64f, -9.12f)
                curveToRelative(0.05f, -0.11f, 0.07f, -0.22f, 0.07f, -0.31f)
                curveToRelative(0.0f, -0.34f, -0.24f, -0.57f, -0.64f, -0.57f)
                horizontalLineTo(4.62f)
                curveToRelative(-0.4f, 0.0f, -0.63f, 0.23f, -0.63f, 0.57f)
                curveToRelative(0.0f, 0.1f, 0.02f, 0.2f, 0.06f, 0.31f)
                curveTo(5.16f, 5.82f, 5.7f, 8.91f, 5.7f, 12.0f)
                reflectiveCurveToRelative(-0.55f, 6.18f, -1.64f, 9.12f)
                curveToRelative(-0.05f, 0.11f, -0.07f, 0.22f, -0.07f, 0.31f)
                curveToRelative(0.0f, 0.33f, 0.23f, 0.57f, 0.63f, 0.57f)
                horizontalLineToRelative(14.75f)
                curveToRelative(0.39f, 0.0f, 0.63f, -0.24f, 0.63f, -0.57f)
                curveToRelative(0.0f, -0.1f, -0.02f, -0.2f, -0.07f, -0.31f)
                close()
            }
        }
        return _panoramaVerticalSelect!!
    }

private var _panoramaVerticalSelect: ImageVector? = null
