/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PowerOff: ImageVector
    get() {
        if (_powerOff != null) {
            return _powerOff!!
        }
        _powerOff = materialIcon(name = "Filled.PowerOff") {
            materialPath {
                moveTo(18.0f, 14.49f)
                lineTo(18.0f, 9.0f)
                curveToRelative(0.0f, -1.0f, -1.01f, -2.01f, -2.0f, -2.0f)
                lineTo(16.0f, 3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(10.0f, 3.0f)
                lineTo(8.0f, 3.0f)
                verticalLineToRelative(2.48f)
                lineToRelative(9.51f, 9.5f)
                lineToRelative(0.49f, -0.49f)
                close()
                moveTo(16.24f, 16.26f)
                lineTo(7.2f, 7.2f)
                lineToRelative(-0.01f, 0.01f)
                lineTo(3.98f, 4.0f)
                lineTo(2.71f, 5.25f)
                lineToRelative(3.36f, 3.36f)
                curveTo(6.04f, 8.74f, 6.0f, 8.87f, 6.0f, 9.0f)
                verticalLineToRelative(5.48f)
                lineTo(9.5f, 18.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(0.48f, -0.48f)
                lineTo(19.45f, 22.0f)
                lineToRelative(1.26f, -1.28f)
                lineToRelative(-4.47f, -4.46f)
                close()
            }
        }
        return _powerOff!!
    }

private var _powerOff: ImageVector? = null
