/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ReportOff: ImageVector
    get() {
        if (_reportOff != null) {
            return _reportOff!!
        }
        _reportOff = materialIcon(name = "Filled.ReportOff") {
            materialPath {
                moveTo(11.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.92f)
                lineToRelative(6.91f, 6.91f)
                lineToRelative(1.09f, -1.1f)
                lineTo(21.0f, 8.27f)
                lineTo(15.73f, 3.0f)
                lineTo(8.27f, 3.0f)
                lineTo(7.18f, 4.1f)
                lineTo(11.0f, 7.92f)
                close()
                moveTo(22.27f, 21.73f)
                lineToRelative(-20.0f, -20.01f)
                lineTo(1.0f, 2.99f)
                lineToRelative(3.64f, 3.64f)
                lineTo(3.0f, 8.27f)
                verticalLineToRelative(7.46f)
                lineTo(8.27f, 21.0f)
                horizontalLineToRelative(7.46f)
                lineToRelative(1.64f, -1.63f)
                lineTo(21.0f, 23.0f)
                lineToRelative(1.27f, -1.27f)
                close()
                moveTo(12.0f, 17.3f)
                curveToRelative(-0.72f, 0.0f, -1.3f, -0.58f, -1.3f, -1.3f)
                reflectiveCurveToRelative(0.58f, -1.3f, 1.3f, -1.3f)
                reflectiveCurveToRelative(1.3f, 0.58f, 1.3f, 1.3f)
                reflectiveCurveToRelative(-0.58f, 1.3f, -1.3f, 1.3f)
                close()
            }
        }
        return _reportOff!!
    }

private var _reportOff: ImageVector? = null
