/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Sailing: ImageVector
    get() {
        if (_sailing != null) {
            return _sailing!!
        }
        _sailing = materialIcon(name = "Filled.Sailing") {
            materialPath {
                moveTo(11.0f, 13.5f)
                verticalLineTo(2.0f)
                lineTo(3.0f, 13.5f)
                horizontalLineTo(11.0f)
                close()
                moveTo(21.0f, 13.5f)
                curveTo(21.0f, 6.5f, 14.5f, 1.0f, 12.5f, 1.0f)
                curveToRelative(0.0f, 0.0f, 1.0f, 3.0f, 1.0f, 6.5f)
                reflectiveCurveToRelative(-1.0f, 6.0f, -1.0f, 6.0f)
                horizontalLineTo(21.0f)
                close()
                moveTo(22.0f, 15.0f)
                horizontalLineTo(2.0f)
                curveToRelative(0.31f, 1.53f, 1.16f, 2.84f, 2.33f, 3.73f)
                curveTo(4.98f, 18.46f, 5.55f, 18.01f, 6.0f, 17.5f)
                curveTo(6.73f, 18.34f, 7.8f, 19.0f, 9.0f, 19.0f)
                reflectiveCurveToRelative(2.27f, -0.66f, 3.0f, -1.5f)
                curveToRelative(0.73f, 0.84f, 1.8f, 1.5f, 3.0f, 1.5f)
                reflectiveCurveToRelative(2.26f, -0.66f, 3.0f, -1.5f)
                curveToRelative(0.45f, 0.51f, 1.02f, 0.96f, 1.67f, 1.23f)
                curveTo(20.84f, 17.84f, 21.69f, 16.53f, 22.0f, 15.0f)
                close()
                moveTo(22.0f, 23.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-1.04f, 0.0f, -2.08f, -0.35f, -3.0f, -1.0f)
                curveToRelative(-1.83f, 1.3f, -4.17f, 1.3f, -6.0f, 0.0f)
                curveToRelative(-1.83f, 1.3f, -4.17f, 1.3f, -6.0f, 0.0f)
                curveToRelative(-0.91f, 0.65f, -1.96f, 1.0f, -3.0f, 1.0f)
                horizontalLineTo(2.0f)
                lineToRelative(0.0f, 2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.03f, 0.0f, 2.05f, -0.25f, 3.0f, -0.75f)
                curveToRelative(1.89f, 1.0f, 4.11f, 1.0f, 6.0f, 0.0f)
                curveToRelative(1.89f, 1.0f, 4.11f, 1.0f, 6.0f, 0.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.95f, 0.5f, 1.97f, 0.75f, 3.0f, 0.75f)
                horizontalLineTo(22.0f)
                close()
            }
        }
        return _sailing!!
    }

private var _sailing: ImageVector? = null
