/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Soap: ImageVector
    get() {
        if (_soap != null) {
            return _soap!!
        }
        _soap = materialIcon(name = "Filled.Soap") {
            materialPath {
                moveTo(9.12f, 5.0f)
                lineToRelative(-7.18f, 6.79f)
                curveTo(1.34f, 12.35f, 1.0f, 13.14f, 1.0f, 13.97f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                horizontalLineToRelative(6.25f)
                horizontalLineTo(12.0f)
                horizontalLineToRelative(5.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(7.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveTo(20.44f, 17.0f, 19.75f, 17.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(8.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(6.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveTo(19.44f, 10.0f, 18.75f, 10.0f)
                horizontalLineTo(8.86f)
                curveToRelative(0.64f, -1.11f, 1.48f, -2.58f, 1.49f, -2.61f)
                curveToRelative(0.09f, -0.16f, 0.14f, -0.33f, 0.14f, -0.53f)
                curveToRelative(0.0f, -0.26f, -0.09f, -0.5f, -0.26f, -0.7f)
                curveTo(10.22f, 6.12f, 9.12f, 5.0f, 9.12f, 5.0f)
                lineTo(9.12f, 5.0f)
                close()
                moveTo(14.0f, 6.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                reflectiveCurveTo(14.41f, 7.75f, 14.0f, 7.75f)
                reflectiveCurveTo(13.25f, 7.41f, 13.25f, 7.0f)
                reflectiveCurveTo(13.59f, 6.25f, 14.0f, 6.25f)
                moveTo(14.0f, 4.75f)
                curveToRelative(-1.24f, 0.0f, -2.25f, 1.01f, -2.25f, 2.25f)
                reflectiveCurveTo(12.76f, 9.25f, 14.0f, 9.25f)
                reflectiveCurveTo(16.25f, 8.24f, 16.25f, 7.0f)
                reflectiveCurveTo(15.24f, 4.75f, 14.0f, 4.75f)
                lineTo(14.0f, 4.75f)
                close()
                moveTo(19.75f, 5.5f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                reflectiveCurveToRelative(-0.22f, 0.5f, -0.5f, 0.5f)
                reflectiveCurveToRelative(-0.5f, -0.22f, -0.5f, -0.5f)
                reflectiveCurveTo(19.47f, 5.5f, 19.75f, 5.5f)
                moveTo(19.75f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(20.85f, 4.0f, 19.75f, 4.0f)
                lineTo(19.75f, 4.0f)
                close()
                moveTo(16.5f, 1.0f)
                curveTo(15.67f, 1.0f, 15.0f, 1.67f, 15.0f, 2.5f)
                reflectiveCurveTo(15.67f, 4.0f, 16.5f, 4.0f)
                curveTo(17.33f, 4.0f, 18.0f, 3.33f, 18.0f, 2.5f)
                reflectiveCurveTo(17.33f, 1.0f, 16.5f, 1.0f)
                close()
            }
        }
        return _soap!!
    }

private var _soap: ImageVector? = null
