/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Stadium: ImageVector
    get() {
        if (_stadium != null) {
            return _stadium!!
        }
        _stadium = materialIcon(name = "Filled.Stadium") {
            materialPath {
                moveTo(7.0f, 5.0f)
                lineTo(3.0f, 7.0f)
                verticalLineTo(3.0f)
                lineTo(7.0f, 5.0f)
                close()
                moveTo(18.0f, 3.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(4.0f, -2.0f)
                lineTo(18.0f, 3.0f)
                close()
                moveTo(11.0f, 2.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(4.0f, -2.0f)
                lineTo(11.0f, 2.0f)
                close()
                moveTo(5.0f, 10.04f)
                curveTo(6.38f, 10.53f, 8.77f, 11.0f, 12.0f, 11.0f)
                reflectiveCurveToRelative(5.62f, -0.47f, 7.0f, -0.96f)
                curveTo(19.0f, 9.86f, 16.22f, 9.0f, 12.0f, 9.0f)
                reflectiveCurveTo(5.0f, 9.86f, 5.0f, 10.04f)
                close()
                moveTo(15.0f, 17.0f)
                horizontalLineTo(9.0f)
                lineToRelative(0.0f, 4.88f)
                curveTo(4.94f, 21.49f, 2.0f, 20.34f, 2.0f, 19.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(0.0f, -1.66f, 4.48f, -3.0f, 10.0f, -3.0f)
                reflectiveCurveToRelative(10.0f, 1.34f, 10.0f, 3.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.34f, -2.94f, 2.48f, -7.0f, 2.87f)
                lineTo(15.0f, 17.0f)
                close()
            }
        }
        return _stadium!!
    }

private var _stadium: ImageVector? = null
