/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.AddHomeWork: ImageVector
    get() {
        if (_addHomeWork != null) {
            return _addHomeWork!!
        }
        _addHomeWork = materialIcon(name = "Outlined.AddHomeWork") {
            materialPath {
                moveTo(11.0f, 14.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-6.97f)
                lineToRelative(5.0f, -3.57f)
                lineToRelative(5.0f, 3.57f)
                verticalLineToRelative(1.08f)
                curveToRelative(0.57f, -0.59f, 1.25f, -1.07f, 2.0f, -1.42f)
                verticalLineTo(11.0f)
                lineTo(8.0f, 6.0f)
                lineToRelative(-7.0f, 5.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.68f)
                curveTo(11.25f, 20.09f, 11.0f, 19.08f, 11.0f, 18.0f)
                verticalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(23.0f, 13.11f)
                verticalLineTo(3.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(1.97f)
                lineToRelative(2.0f, 1.43f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(6.68f)
                curveTo(21.75f, 12.04f, 22.43f, 12.52f, 23.0f, 13.11f)
                close()
            }
            materialPath {
                moveTo(23.0f, 18.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                reflectiveCurveToRelative(-5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveTo(23.0f, 20.76f, 23.0f, 18.0f)
                close()
                moveTo(17.5f, 21.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(15.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.5f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.5f)
                verticalLineTo(21.0f)
                horizontalLineTo(17.5f)
                close()
            }
        }
        return _addHomeWork!!
    }

private var _addHomeWork: ImageVector? = null
