/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BrunchDining: ImageVector
    get() {
        if (_brunchDining != null) {
            return _brunchDining!!
        }
        _brunchDining = materialIcon(name = "Outlined.BrunchDining") {
            materialPath {
                moveTo(2.0f, 21.5f)
                curveTo(2.0f, 21.78f, 2.22f, 22.0f, 2.49f, 22.0f)
                horizontalLineToRelative(13.02f)
                curveToRelative(0.27f, 0.0f, 0.49f, -0.22f, 0.49f, -0.5f)
                verticalLineTo(20.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(21.5f)
                close()
            }
            materialPath {
                moveTo(15.5f, 16.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(2.5f)
                curveTo(2.22f, 16.0f, 2.0f, 16.22f, 2.0f, 16.5f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-1.5f)
                curveTo(16.0f, 16.22f, 15.78f, 16.0f, 15.5f, 16.0f)
                close()
            }
            materialPath {
                moveTo(20.47f, 15.45f)
                curveToRelative(0.99f, -1.07f, 1.53f, -2.48f, 1.53f, -3.94f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(9.47f)
                curveToRelative(0.0f, 1.48f, 0.58f, 2.92f, 1.6f, 4.0f)
                lineToRelative(0.4f, 0.42f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-4.03f)
                lineTo(20.47f, 15.45f)
                close()
                moveTo(18.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(19.03f, 14.07f)
                curveToRelative(-0.65f, -0.71f, -1.03f, -1.65f, -1.03f, -2.6f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.51f)
                curveTo(20.0f, 12.46f, 19.66f, 13.36f, 19.03f, 14.07f)
                close()
            }
        }
        return _brunchDining!!
    }

private var _brunchDining: ImageVector? = null
