/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DeveloperMode: ImageVector
    get() {
        if (_developerMode != null) {
            return _developerMode!!
        }
        _developerMode = materialIcon(name = "Outlined.DeveloperMode") {
            materialPath {
                moveTo(7.0f, 5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                lineTo(19.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -1.99f, -2.0f, -1.99f)
                lineTo(7.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                lineTo(7.0f, 5.0f)
                close()
                moveTo(15.41f, 16.59f)
                lineTo(20.0f, 12.0f)
                lineToRelative(-4.59f, -4.59f)
                lineTo(14.0f, 8.83f)
                lineTo(17.17f, 12.0f)
                lineTo(14.0f, 15.17f)
                lineToRelative(1.41f, 1.42f)
                close()
                moveTo(10.0f, 15.17f)
                lineTo(6.83f, 12.0f)
                lineTo(10.0f, 8.83f)
                lineTo(8.59f, 7.41f)
                lineTo(4.0f, 12.0f)
                lineToRelative(4.59f, 4.59f)
                lineTo(10.0f, 15.17f)
                close()
                moveTo(17.0f, 19.0f)
                lineTo(7.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                lineTo(5.0f, 17.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                close()
            }
        }
        return _developerMode!!
    }

private var _developerMode: ImageVector? = null
