/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Fluorescent: ImageVector
    get() {
        if (_fluorescent != null) {
            return _fluorescent!!
        }
        _fluorescent = materialIcon(name = "Outlined.Fluorescent") {
            materialPath {
                moveTo(5.0f, 15.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(15.0f)
                close()
                moveTo(7.0f, 11.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(11.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.286f, 6.399f)
                lineToRelative(1.79f, -1.802f)
                lineToRelative(1.419f, 1.409f)
                lineToRelative(-1.79f, 1.802f)
                close()
            }
            materialPath {
                moveTo(11.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.29f, 17.71f)
                lineToRelative(1.79f, 1.8f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(-1.8f, -1.79f)
                close()
            }
            materialPath {
                moveTo(3.495f, 6.009f)
                lineToRelative(1.407f, -1.407f)
                lineToRelative(1.789f, 1.789f)
                lineToRelative(-1.407f, 1.407f)
                close()
            }
            materialPath {
                moveTo(3.492f, 18.076f)
                lineToRelative(1.802f, -1.79f)
                lineToRelative(1.409f, 1.419f)
                lineToRelative(-1.802f, 1.79f)
                close()
            }
        }
        return _fluorescent!!
    }

private var _fluorescent: ImageVector? = null
