/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.HdrAuto: ImageVector
    get() {
        if (_hdrAuto != null) {
            return _hdrAuto!!
        }
        _hdrAuto = materialIcon(name = "Outlined.HdrAuto") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -4.41f, 3.59f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.59f, 8.0f, 8.0f)
                curveTo(20.0f, 16.41f, 16.41f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(11.01f, 6.0f)
                lineTo(6.88f, 17.0f)
                horizontalLineToRelative(1.9f)
                lineToRelative(1.0f, -2.81f)
                horizontalLineToRelative(4.44f)
                lineTo(15.21f, 17.0f)
                horizontalLineToRelative(1.9f)
                lineTo(12.98f, 6.0f)
                horizontalLineTo(11.01f)
                close()
                moveTo(10.35f, 12.59f)
                lineToRelative(1.6f, -4.55f)
                horizontalLineToRelative(0.09f)
                lineToRelative(1.6f, 4.55f)
                horizontalLineTo(10.35f)
                close()
            }
        }
        return _hdrAuto!!
    }

private var _hdrAuto: ImageVector? = null
