/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.LogoDev: ImageVector
    get() {
        if (_logoDev != null) {
            return _logoDev!!
        }
        _logoDev = materialIcon(name = "Outlined.LogoDev") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(7.68f, 14.98f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.71f)
                curveToRelative(1.28f, 0.0f, 1.71f, 1.03f, 1.71f, 1.71f)
                lineToRelative(0.0f, 2.56f)
                curveTo(9.42f, 13.95f, 9.0f, 14.98f, 7.68f, 14.98f)
                close()
                moveTo(12.38f, 11.46f)
                verticalLineToRelative(1.07f)
                horizontalLineToRelative(-1.18f)
                verticalLineToRelative(1.39f)
                horizontalLineToRelative(1.93f)
                verticalLineToRelative(1.07f)
                horizontalLineToRelative(-2.25f)
                curveToRelative(-0.4f, 0.01f, -0.74f, -0.31f, -0.75f, -0.71f)
                verticalLineTo(9.75f)
                curveToRelative(-0.01f, -0.4f, 0.31f, -0.74f, 0.71f, -0.75f)
                horizontalLineToRelative(2.28f)
                lineToRelative(0.0f, 1.07f)
                horizontalLineToRelative(-1.92f)
                verticalLineToRelative(1.39f)
                horizontalLineTo(12.38f)
                close()
                moveTo(16.88f, 14.23f)
                curveToRelative(-0.48f, 1.11f, -1.33f, 0.89f, -1.71f, 0.0f)
                lineTo(13.77f, 9.0f)
                horizontalLineToRelative(1.18f)
                lineToRelative(1.07f, 4.11f)
                lineTo(17.09f, 9.0f)
                horizontalLineToRelative(1.18f)
                lineTo(16.88f, 14.23f)
                close()
            }
            materialPath {
                moveTo(7.77f, 10.12f)
                horizontalLineTo(7.14f)
                verticalLineToRelative(3.77f)
                horizontalLineToRelative(0.63f)
                curveToRelative(0.14f, 0.0f, 0.28f, -0.05f, 0.42f, -0.16f)
                curveToRelative(0.14f, -0.1f, 0.21f, -0.26f, 0.21f, -0.47f)
                verticalLineToRelative(-2.52f)
                curveToRelative(0.0f, -0.21f, -0.07f, -0.37f, -0.21f, -0.47f)
                curveTo(8.05f, 10.17f, 7.91f, 10.12f, 7.77f, 10.12f)
                close()
            }
        }
        return _logoDev!!
    }

private var _logoDev: ImageVector? = null
