/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NoDrinks: ImageVector
    get() {
        if (_noDrinks != null) {
            return _noDrinks!!
        }
        _noDrinks = materialIcon(name = "Outlined.NoDrinks") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(8.23f, 8.23f)
                lineTo(11.0f, 14.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.17f)
                lineToRelative(1.78f, 1.78f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(13.0f, 19.0f)
                verticalLineToRelative(-3.17f)
                lineTo(16.17f, 19.0f)
                horizontalLineTo(13.0f)
                close()
                moveTo(7.83f, 5.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(-6.2f, 6.97f)
                lineToRelative(-1.42f, -1.42f)
                lineTo(14.77f, 9.0f)
                horizontalLineToRelative(-2.94f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineToRelative(6.74f)
                lineToRelative(1.78f, -2.0f)
                horizontalLineTo(7.83f)
                close()
            }
        }
        return _noDrinks!!
    }

private var _noDrinks: ImageVector? = null
