/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Power: ImageVector
    get() {
        if (_power != null) {
            return _power!!
        }
        _power = materialIcon(name = "Outlined.Power") {
            materialPath {
                moveTo(16.0f, 9.0f)
                verticalLineToRelative(4.66f)
                lineToRelative(-3.5f, 3.51f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.83f)
                lineTo(8.0f, 13.65f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(8.0f)
                moveToRelative(0.0f, -6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-0.01f)
                curveTo(6.9f, 6.99f, 6.0f, 7.89f, 6.0f, 8.98f)
                verticalLineToRelative(5.52f)
                lineTo(9.5f, 18.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(3.5f, -3.51f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                verticalLineTo(3.0f)
                close()
            }
        }
        return _power!!
    }

private var _power: ImageVector? = null
