/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Psychology: ImageVector
    get() {
        if (_psychology != null) {
            return _psychology!!
        }
        _psychology = materialIcon(name = "Outlined.Psychology") {
            materialPath {
                moveTo(15.82f, 7.22f)
                lineToRelative(-1.0f, 0.4f)
                curveToRelative(-0.21f, -0.16f, -0.43f, -0.29f, -0.67f, -0.39f)
                lineTo(14.0f, 6.17f)
                curveTo(13.98f, 6.07f, 13.9f, 6.0f, 13.8f, 6.0f)
                horizontalLineToRelative(-1.6f)
                curveToRelative(-0.1f, 0.0f, -0.18f, 0.07f, -0.19f, 0.17f)
                lineToRelative(-0.15f, 1.06f)
                curveToRelative(-0.24f, 0.1f, -0.47f, 0.23f, -0.67f, 0.39f)
                lineToRelative(-1.0f, -0.4f)
                curveToRelative(-0.09f, -0.03f, -0.2f, 0.0f, -0.24f, 0.09f)
                lineToRelative(-0.8f, 1.38f)
                curveToRelative(-0.05f, 0.09f, -0.03f, 0.2f, 0.05f, 0.26f)
                lineToRelative(0.85f, 0.66f)
                curveTo(10.02f, 9.73f, 10.0f, 9.87f, 10.0f, 10.0f)
                curveToRelative(0.0f, 0.13f, 0.01f, 0.26f, 0.03f, 0.39f)
                lineToRelative(-0.84f, 0.66f)
                curveToRelative(-0.08f, 0.06f, -0.1f, 0.17f, -0.05f, 0.25f)
                lineToRelative(0.8f, 1.39f)
                curveToRelative(0.05f, 0.09f, 0.15f, 0.12f, 0.25f, 0.09f)
                lineToRelative(0.99f, -0.4f)
                curveToRelative(0.21f, 0.16f, 0.43f, 0.29f, 0.68f, 0.39f)
                lineTo(12.0f, 13.83f)
                curveToRelative(0.02f, 0.1f, 0.1f, 0.17f, 0.2f, 0.17f)
                horizontalLineToRelative(1.6f)
                curveToRelative(0.1f, 0.0f, 0.18f, -0.07f, 0.2f, -0.17f)
                lineToRelative(0.15f, -1.06f)
                curveToRelative(0.24f, -0.1f, 0.47f, -0.23f, 0.67f, -0.39f)
                lineToRelative(0.99f, 0.4f)
                curveToRelative(0.09f, 0.04f, 0.2f, 0.0f, 0.24f, -0.09f)
                lineToRelative(0.8f, -1.39f)
                curveToRelative(0.05f, -0.09f, 0.03f, -0.19f, -0.05f, -0.25f)
                lineToRelative(-0.83f, -0.66f)
                curveTo(15.99f, 10.26f, 16.0f, 10.13f, 16.0f, 10.0f)
                curveToRelative(0.0f, -0.14f, -0.01f, -0.27f, -0.03f, -0.39f)
                lineToRelative(0.85f, -0.66f)
                curveToRelative(0.08f, -0.06f, 0.1f, -0.17f, 0.05f, -0.26f)
                lineToRelative(-0.8f, -1.38f)
                curveTo(16.02f, 7.22f, 15.91f, 7.19f, 15.82f, 7.22f)
                close()
                moveTo(13.0f, 11.43f)
                curveToRelative(-0.79f, 0.0f, -1.43f, -0.64f, -1.43f, -1.43f)
                reflectiveCurveTo(12.21f, 8.57f, 13.0f, 8.57f)
                reflectiveCurveToRelative(1.43f, 0.64f, 1.43f, 1.43f)
                reflectiveCurveTo(13.79f, 11.43f, 13.0f, 11.43f)
                close()
            }
            materialPath {
                moveTo(19.94f, 9.06f)
                curveToRelative(-0.43f, -3.27f, -3.23f, -5.86f, -6.53f, -6.05f)
                curveTo(13.27f, 3.0f, 13.14f, 3.0f, 13.0f, 3.0f)
                curveTo(9.47f, 3.0f, 6.57f, 5.61f, 6.08f, 9.0f)
                lineToRelative(-1.93f, 3.48f)
                curveTo(3.74f, 13.14f, 4.22f, 14.0f, 5.0f, 14.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-4.68f)
                curveTo(18.62f, 15.07f, 20.35f, 12.24f, 19.94f, 9.06f)
                close()
                moveTo(14.89f, 14.63f)
                lineTo(14.0f, 15.05f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(6.7f)
                lineToRelative(1.33f, -2.33f)
                curveTo(8.21f, 7.06f, 10.35f, 5.0f, 13.0f, 5.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                curveTo(18.0f, 12.09f, 16.71f, 13.88f, 14.89f, 14.63f)
                close()
            }
        }
        return _psychology!!
    }

private var _psychology: ImageVector? = null
