/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RemoveShoppingCart: ImageVector
    get() {
        if (_removeShoppingCart != null) {
            return _removeShoppingCart!!
        }
        _removeShoppingCart = materialIcon(name = "Outlined.RemoveShoppingCart") {
            materialPath {
                moveTo(1.41f, 1.13f)
                lineTo(0.0f, 2.54f)
                lineToRelative(4.39f, 4.39f)
                lineToRelative(2.21f, 4.66f)
                lineToRelative(-1.35f, 2.45f)
                curveToRelative(-0.16f, 0.28f, -0.25f, 0.61f, -0.25f, 0.96f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.46f)
                lineToRelative(1.38f, 1.38f)
                curveToRelative(-0.5f, 0.36f, -0.83f, 0.95f, -0.83f, 1.62f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 1.99f, 2.0f)
                curveToRelative(0.67f, 0.0f, 1.26f, -0.33f, 1.62f, -0.84f)
                lineTo(21.46f, 24.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(1.41f, 1.13f)
                close()
                moveTo(7.0f, 15.0f)
                lineToRelative(1.1f, -2.0f)
                horizontalLineToRelative(2.36f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(20.0f, 4.0f)
                horizontalLineTo(7.12f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(9.19f)
                lineToRelative(-2.76f, 5.0f)
                horizontalLineToRelative(-1.44f)
                lineToRelative(1.94f, 1.94f)
                curveToRelative(0.54f, -0.14f, 0.99f, -0.49f, 1.25f, -0.97f)
                lineToRelative(3.58f, -6.49f)
                curveTo(21.25f, 4.82f, 20.76f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(7.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -1.99f, 0.9f, -1.99f, 2.0f)
                reflectiveCurveTo(5.9f, 22.0f, 7.0f, 22.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _removeShoppingCart!!
    }

private var _removeShoppingCart: ImageVector? = null
