/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SportsMartialArts: ImageVector
    get() {
        if (_sportsMartialArts != null) {
            return _sportsMartialArts!!
        }
        _sportsMartialArts = materialIcon(name = "Outlined.SportsMartialArts") {
            materialPath {
                moveTo(19.8f, 2.0f)
                lineToRelative(-8.2f, 6.7f)
                lineToRelative(-1.21f, -1.04f)
                lineToRelative(3.6f, -2.08f)
                lineToRelative(-4.58f, -4.58f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(2.74f, 2.74f)
                lineToRelative(-5.74f, 3.31f)
                lineToRelative(-1.19f, 4.29f)
                lineToRelative(2.46f, 4.25f)
                lineToRelative(1.73f, -1.0f)
                lineToRelative(-2.03f, -3.52f)
                lineToRelative(0.35f, -1.3f)
                lineToRelative(3.18f, 1.82f)
                lineToRelative(0.5f, 9.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.5f, -10.0f)
                lineToRelative(8.5f, -8.6f)
                close()
            }
            materialPath {
                moveTo(5.0f, 5.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _sportsMartialArts!!
    }

private var _sportsMartialArts: ImageVector? = null
