/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Wash: ImageVector
    get() {
        if (_wash != null) {
            return _wash!!
        }
        _wash = materialIcon(name = "Outlined.Wash") {
            materialPath {
                moveTo(20.75f, 16.0f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(6.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                curveToRelative(0.0f, -0.67f, -0.53f, -1.2f, -1.18f, -1.24f)
                lineTo(8.87f, 10.0f)
                lineToRelative(1.48f, -2.6f)
                curveToRelative(0.09f, -0.17f, 0.14f, -0.34f, 0.14f, -0.54f)
                curveToRelative(0.0f, -0.26f, -0.09f, -0.5f, -0.26f, -0.7f)
                lineTo(9.12f, 5.0f)
                lineToRelative(-7.18f, 6.8f)
                curveTo(1.34f, 12.36f, 1.0f, 13.15f, 1.0f, 13.97f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                horizontalLineToRelative(13.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(7.75f)
                curveToRelative(0.69f, 0.0f, 1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveTo(20.44f, 17.0f, 19.75f, 17.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(20.75f)
                close()
                moveTo(10.0f, 21.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-6.0f)
                curveToRelative(0.0f, -0.39f, 0.23f, -0.64f, 0.36f, -0.75f)
                lineTo(7.0f, 9.87f)
                verticalLineTo(12.0f)
                lineToRelative(3.0f, 0.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(13.5f, 9.0f)
                curveTo(14.33f, 9.0f, 15.0f, 8.33f, 15.0f, 7.5f)
                curveTo(15.0f, 6.66f, 13.5f, 5.0f, 13.5f, 5.0f)
                reflectiveCurveTo(12.0f, 6.66f, 12.0f, 7.5f)
                curveTo(12.0f, 8.33f, 12.67f, 9.0f, 13.5f, 9.0f)
                close()
                moveTo(18.5f, 1.0f)
                curveToRelative(0.0f, 0.0f, -2.5f, 2.83f, -2.5f, 4.5f)
                curveTo(16.0f, 6.88f, 17.12f, 8.0f, 18.5f, 8.0f)
                reflectiveCurveTo(21.0f, 6.88f, 21.0f, 5.5f)
                curveTo(21.0f, 3.83f, 18.5f, 1.0f, 18.5f, 1.0f)
                close()
                moveTo(18.5f, 6.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.4f, 0.43f, -1.22f, 1.0f, -2.05f)
                curveToRelative(0.57f, 0.83f, 1.0f, 1.65f, 1.0f, 2.05f)
                curveTo(19.5f, 6.05f, 19.05f, 6.5f, 18.5f, 6.5f)
                close()
            }
        }
        return _wash!!
    }

private var _wash: ImageVector? = null
