/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.WineBar: ImageVector
    get() {
        if (_wineBar != null) {
            return _wineBar!!
        }
        _wineBar = materialIcon(name = "Outlined.WineBar") {
            materialPath {
                moveTo(6.0f, 3.0f)
                lineToRelative(0.0f, 6.0f)
                curveToRelative(0.0f, 2.97f, 2.16f, 5.43f, 5.0f, 5.91f)
                verticalLineTo(19.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-4.09f)
                curveToRelative(2.84f, -0.48f, 5.0f, -2.94f, 5.0f, -5.91f)
                verticalLineTo(3.0f)
                horizontalLineTo(6.0f)
                close()
                moveTo(12.0f, 13.0f)
                curveToRelative(-1.86f, 0.0f, -3.41f, -1.28f, -3.86f, -3.0f)
                horizontalLineToRelative(7.72f)
                curveTo(15.41f, 11.72f, 13.86f, 13.0f, 12.0f, 13.0f)
                close()
                moveTo(16.0f, 8.0f)
                horizontalLineTo(8.0f)
                lineToRelative(0.0f, -3.0f)
                horizontalLineToRelative(8.0f)
                lineTo(16.0f, 8.0f)
                close()
            }
        }
        return _wineBar!!
    }

private var _wineBar: ImageVector? = null
