/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AddHome: ImageVector
    get() {
        if (_addHome != null) {
            return _addHome!!
        }
        _addHome = materialIcon(name = "Rounded.AddHome") {
            materialPath {
                moveTo(16.53f, 11.16f)
                curveToRelative(1.23f, -0.26f, 2.4f, -0.18f, 3.47f, 0.14f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.63f, -0.3f, -1.22f, -0.8f, -1.6f)
                lineToRelative(-6.0f, -4.5f)
                curveToRelative(-0.71f, -0.53f, -1.69f, -0.53f, -2.4f, 0.0f)
                lineToRelative(-6.0f, 4.5f)
                curveTo(4.3f, 8.78f, 4.0f, 9.37f, 4.0f, 10.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(5.68f)
                curveToRelative(-0.61f, -1.28f, -0.86f, -2.77f, -0.55f, -4.35f)
                curveTo(11.65f, 13.93f, 13.82f, 11.74f, 16.53f, 11.16f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(21.0f, 18.5f)
                horizontalLineToRelative(-2.5f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(15.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.5f)
                horizontalLineTo(21.0f)
                verticalLineTo(18.5f)
                close()
            }
        }
        return _addHome!!
    }

private var _addHome: ImageVector? = null
