/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BatchPrediction: ImageVector
    get() {
        if (_batchPrediction != null) {
            return _batchPrediction!!
        }
        _batchPrediction = materialIcon(name = "Rounded.BatchPrediction") {
            materialPath {
                moveTo(17.0f, 8.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(10.0f)
                curveTo(19.0f, 8.9f, 18.1f, 8.0f, 17.0f, 8.0f)
                close()
                moveTo(12.0f, 20.5f)
                lineTo(12.0f, 20.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(0.5f)
                curveTo(13.0f, 20.05f, 12.55f, 20.5f, 12.0f, 20.5f)
                close()
                moveTo(13.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.5f, -2.5f, -3.0f, -2.5f, -5.0f)
                curveToRelative(0.0f, -1.93f, 1.57f, -3.5f, 3.5f, -3.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, 1.57f, 3.5f, 3.5f)
                curveTo(15.5f, 15.0f, 13.0f, 16.5f, 13.0f, 18.0f)
                close()
                moveTo(18.0f, 6.5f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(0.0f)
                curveTo(6.0f, 5.67f, 6.67f, 5.0f, 7.5f, 5.0f)
                horizontalLineToRelative(9.0f)
                curveTo(17.33f, 5.0f, 18.0f, 5.67f, 18.0f, 6.5f)
                lineTo(18.0f, 6.5f)
                close()
                moveTo(17.0f, 3.5f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(0.0f)
                curveTo(7.0f, 2.67f, 7.67f, 2.0f, 8.5f, 2.0f)
                horizontalLineToRelative(7.0f)
                curveTo(16.33f, 2.0f, 17.0f, 2.67f, 17.0f, 3.5f)
                lineTo(17.0f, 3.5f)
                close()
            }
        }
        return _batchPrediction!!
    }

private var _batchPrediction: ImageVector? = null
