/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BrowserUpdated: ImageVector
    get() {
        if (_browserUpdated != null) {
            return _browserUpdated!!
        }
        _browserUpdated = materialIcon(name = "Rounded.BrowserUpdated") {
            materialPath {
                moveTo(15.0f, 3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.59f)
                curveToRelative(0.89f, 0.0f, 1.34f, 1.08f, 0.71f, 1.71f)
                lineToRelative(-2.59f, 2.59f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(-2.59f, -2.59f)
                curveTo(11.08f, 11.08f, 11.52f, 10.0f, 12.41f, 10.0f)
                horizontalLineTo(14.0f)
                verticalLineTo(4.0f)
                curveTo(14.0f, 3.45f, 14.45f, 3.0f, 15.0f, 3.0f)
                close()
                moveTo(6.0f, 19.59f)
                curveTo(6.0f, 20.37f, 6.63f, 21.0f, 7.41f, 21.0f)
                horizontalLineToRelative(9.17f)
                curveToRelative(0.78f, 0.0f, 1.41f, -0.63f, 1.41f, -1.41f)
                curveToRelative(0.0f, -0.72f, -0.44f, -1.03f, -1.0f, -1.59f)
                horizontalLineToRelative(3.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(5.0f)
                lineToRelative(7.0f, 0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(4.0f, 3.0f)
                curveTo(2.9f, 3.0f, 2.0f, 3.9f, 2.0f, 5.0f)
                verticalLineToRelative(11.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(3.0f)
                curveTo(6.45f, 18.55f, 6.0f, 18.87f, 6.0f, 19.59f)
                close()
            }
        }
        return _browserUpdated!!
    }

private var _browserUpdated: ImageVector? = null
