/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CloudSync: ImageVector
    get() {
        if (_cloudSync != null) {
            return _cloudSync!!
        }
        _cloudSync = materialIcon(name = "Rounded.CloudSync") {
            materialPath {
                moveTo(24.0f, 17.48f)
                curveToRelative(0.0f, 1.38f, -1.12f, 2.5f, -2.5f, 2.5f)
                lineTo(15.0f, 20.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                curveToRelative(0.0f, -1.6f, 1.26f, -2.9f, 2.84f, -2.98f)
                curveTo(15.4f, 12.83f, 16.6f, 12.0f, 18.0f, 12.0f)
                curveToRelative(1.76f, 0.0f, 3.2f, 1.3f, 3.45f, 2.99f)
                curveToRelative(0.02f, 0.0f, 0.03f, -0.01f, 0.05f, -0.01f)
                curveTo(22.88f, 14.98f, 24.0f, 16.1f, 24.0f, 17.48f)
                close()
                moveTo(10.0f, 15.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.44f)
                curveToRelative(-1.22f, -1.1f, -2.0f, -2.67f, -2.0f, -4.44f)
                curveToRelative(0.0f, -2.38f, 1.39f, -4.43f, 3.4f, -5.4f)
                curveTo(9.77f, 6.42f, 10.0f, 6.04f, 10.0f, 5.63f)
                curveToRelative(0.0f, -0.71f, -0.73f, -1.18f, -1.37f, -0.88f)
                curveTo(5.89f, 6.03f, 4.0f, 8.79f, 4.0f, 12.0f)
                curveToRelative(0.0f, 2.4f, 1.06f, 4.54f, 2.73f, 6.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(15.0f)
                close()
                moveTo(19.0f, 6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(7.56f)
                curveToRelative(0.98f, 0.89f, 1.68f, 2.08f, 1.92f, 3.44f)
                lineToRelative(2.02f, 0.0f)
                curveToRelative(-0.25f, -1.99f, -1.23f, -3.74f, -2.66f, -5.0f)
                horizontalLineTo(19.0f)
                close()
            }
        }
        return _cloudSync!!
    }

private var _cloudSync: ImageVector? = null
