/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ContactPhone: ImageVector
    get() {
        if (_contactPhone != null) {
            return _contactPhone!!
        }
        _contactPhone = materialIcon(name = "Rounded.ContactPhone") {
            materialPath {
                moveTo(22.0f, 3.0f)
                lineTo(2.0f, 3.0f)
                curveTo(0.9f, 3.0f, 0.0f, 3.9f, 0.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(20.0f)
                curveToRelative(1.1f, 0.0f, 1.99f, -0.9f, 1.99f, -2.0f)
                lineTo(24.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(8.0f, 6.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.34f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveToRelative(-3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                close()
                moveTo(14.0f, 18.0f)
                lineTo(2.0f, 18.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -2.0f, 4.0f, -3.1f, 6.0f, -3.1f)
                reflectiveCurveToRelative(6.0f, 1.1f, 6.0f, 3.1f)
                verticalLineToRelative(1.0f)
                close()
                moveTo(17.85f, 14.0f)
                horizontalLineToRelative(1.39f)
                curveToRelative(0.16f, 0.0f, 0.3f, 0.07f, 0.4f, 0.2f)
                lineToRelative(1.1f, 1.45f)
                curveToRelative(0.15f, 0.2f, 0.13f, 0.48f, -0.05f, 0.65f)
                lineToRelative(-1.36f, 1.36f)
                curveToRelative(-0.18f, 0.18f, -0.48f, 0.2f, -0.67f, 0.04f)
                curveToRelative(-1.13f, -0.96f, -1.97f, -2.25f, -2.38f, -3.71f)
                curveToRelative(-0.18f, -0.63f, -0.28f, -1.3f, -0.28f, -1.99f)
                reflectiveCurveToRelative(0.1f, -1.36f, 0.28f, -2.0f)
                curveToRelative(0.41f, -1.47f, 1.25f, -2.75f, 2.38f, -3.71f)
                curveToRelative(0.2f, -0.17f, 0.49f, -0.14f, 0.67f, 0.04f)
                lineToRelative(1.36f, 1.36f)
                curveToRelative(0.18f, 0.18f, 0.2f, 0.46f, 0.05f, 0.65f)
                lineToRelative(-1.1f, 1.45f)
                curveToRelative(-0.09f, 0.13f, -0.24f, 0.2f, -0.4f, 0.2f)
                horizontalLineToRelative(-1.39f)
                curveToRelative(-0.22f, 0.63f, -0.35f, 1.3f, -0.35f, 2.0f)
                reflectiveCurveToRelative(0.13f, 1.38f, 0.35f, 2.01f)
                close()
            }
        }
        return _contactPhone!!
    }

private var _contactPhone: ImageVector? = null
