/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ContentPasteSearch: ImageVector
    get() {
        if (_contentPasteSearch != null) {
            return _contentPasteSearch!!
        }
        _contentPasteSearch = materialIcon(name = "Rounded.ContentPasteSearch") {
            materialPath {
                moveTo(5.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.18f)
                curveTo(14.4f, 1.84f, 13.3f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(9.6f, 1.84f, 9.18f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(5.0f)
                close()
                moveTo(12.0f, 3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(11.45f, 3.0f, 12.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(22.3f, 20.9f)
                lineToRelative(-2.0f, -2.0f)
                curveToRelative(0.58f, -1.01f, 0.95f, -2.23f, 0.51f, -3.65f)
                curveToRelative(-0.53f, -1.72f, -2.04f, -3.05f, -3.84f, -3.22f)
                curveToRelative(-2.87f, -0.28f, -5.23f, 2.07f, -4.95f, 4.95f)
                curveToRelative(0.18f, 1.79f, 1.5f, 3.31f, 3.22f, 3.84f)
                curveToRelative(1.43f, 0.44f, 2.64f, 0.07f, 3.65f, -0.51f)
                lineToRelative(2.0f, 2.0f)
                curveToRelative(0.39f, 0.39f, 1.01f, 0.39f, 1.4f, 0.0f)
                reflectiveCurveTo(22.69f, 21.29f, 22.3f, 20.9f)
                close()
                moveTo(16.5f, 19.0f)
                curveToRelative(-1.4f, 0.0f, -2.5f, -1.1f, -2.5f, -2.5f)
                curveToRelative(0.0f, -1.4f, 1.1f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.1f, 2.5f, 2.5f)
                curveTo(19.0f, 17.9f, 17.9f, 19.0f, 16.5f, 19.0f)
                close()
            }
        }
        return _contentPasteSearch!!
    }

private var _contentPasteSearch: ImageVector? = null
