/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CurrencyYuan: ImageVector
    get() {
        if (_currencyYuan != null) {
            return _currencyYuan!!
        }
        _currencyYuan = materialIcon(name = "Rounded.CurrencyYuan") {
            materialPath {
                moveTo(12.0f, 21.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.72f)
                lineTo(5.98f, 4.54f)
                curveTo(5.55f, 3.87f, 6.03f, 3.0f, 6.82f, 3.0f)
                curveToRelative(0.34f, 0.0f, 0.66f, 0.17f, 0.84f, 0.46f)
                lineTo(12.0f, 10.29f)
                lineToRelative(4.34f, -6.83f)
                curveTo(16.52f, 3.17f, 16.84f, 3.0f, 17.18f, 3.0f)
                curveToRelative(0.79f, 0.0f, 1.27f, 0.87f, 0.84f, 1.54f)
                lineTo(13.28f, 12.0f)
                horizontalLineTo(17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(6.0f)
                curveTo(13.0f, 20.55f, 12.55f, 21.0f, 12.0f, 21.0f)
                close()
            }
        }
        return _currencyYuan!!
    }

private var _currencyYuan: ImageVector? = null
