/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DoneOutline: ImageVector
    get() {
        if (_doneOutline != null) {
            return _doneOutline!!
        }
        _doneOutline = materialIcon(name = "Rounded.DoneOutline") {
            materialPath {
                moveTo(20.47f, 5.63f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.01f, 0.0f, 1.4f)
                lineTo(9.13f, 18.37f)
                curveToRelative(-0.39f, 0.39f, -1.01f, 0.39f, -1.4f, 0.0f)
                lineToRelative(-4.2f, -4.2f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.01f, 0.0f, -1.4f)
                curveToRelative(0.39f, -0.39f, 1.01f, -0.39f, 1.4f, 0.0f)
                lineToRelative(3.5f, 3.5f)
                lineTo(19.07f, 5.63f)
                curveToRelative(0.39f, -0.39f, 1.01f, -0.39f, 1.4f, 0.0f)
                close()
                moveTo(18.36f, 3.51f)
                lineToRelative(-9.93f, 9.93f)
                lineToRelative(-2.79f, -2.79f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineToRelative(-1.4f, 1.4f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(5.6f, 5.6f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineTo(22.59f, 7.74f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-1.4f, -1.4f)
                curveToRelative(-0.79f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                close()
            }
        }
        return _doneOutline!!
    }

private var _doneOutline: ImageVector? = null
