/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Face3: ImageVector
    get() {
        if (_face3 != null) {
            return _face3!!
        }
        _face3 = materialIcon(name = "Rounded.Face3") {
            materialPath {
                moveTo(9.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(22.91f, 11.96f)
                curveTo(22.39f, 6.32f, 17.66f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(1.61f, 6.32f, 1.09f, 11.96f)
                lineToRelative(-0.9f, 9.86f)
                curveTo(0.09f, 22.99f, 1.01f, 24.0f, 2.19f, 24.0f)
                horizontalLineToRelative(19.62f)
                curveToRelative(1.18f, 0.0f, 2.1f, -1.01f, 1.99f, -2.18f)
                lineTo(22.91f, 11.96f)
                close()
                moveTo(4.54f, 9.13f)
                curveTo(5.41f, 9.68f, 6.43f, 10.0f, 7.5f, 10.0f)
                curveTo(9.36f, 10.0f, 11.0f, 9.07f, 12.0f, 7.65f)
                curveTo(13.0f, 9.07f, 14.64f, 10.0f, 16.5f, 10.0f)
                curveToRelative(1.07f, 0.0f, 2.09f, -0.32f, 2.96f, -0.87f)
                curveTo(19.8f, 10.02f, 20.0f, 10.99f, 20.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, -3.59f, 8.0f, -8.0f, 8.0f)
                reflectiveCurveToRelative(-8.0f, -3.59f, -8.0f, -8.0f)
                curveTo(4.0f, 10.99f, 4.2f, 10.02f, 4.54f, 9.13f)
                close()
            }
        }
        return _face3!!
    }

private var _face3: ImageVector? = null
