/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Flood: ImageVector
    get() {
        if (_flood != null) {
            return _flood!!
        }
        _flood = materialIcon(name = "Rounded.Flood") {
            materialPath {
                moveTo(18.67f, 19.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                curveToRelative(-1.24f, 0.0f, -1.38f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.54f, 0.0f, -1.96f, 0.62f, -2.67f, 0.88f)
                curveTo(2.27f, 20.03f, 2.0f, 20.4f, 2.0f, 20.83f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.71f, 0.72f, 1.19f, 1.38f, 0.94f)
                curveTo(4.15f, 21.48f, 4.49f, 21.0f, 5.34f, 21.0f)
                curveToRelative(1.24f, 0.0f, 1.38f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.1f, -1.0f, 3.34f, -1.0f)
                curveToRelative(1.22f, 0.0f, 1.4f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.93f, 0.0f, 2.1f, -1.0f, 3.33f, -1.0f)
                curveToRelative(0.84f, 0.0f, 1.18f, 0.47f, 1.95f, 0.77f)
                curveToRelative(0.66f, 0.26f, 1.38f, -0.23f, 1.38f, -0.94f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.42f, -0.27f, -0.8f, -0.67f, -0.94f)
                curveTo(20.62f, 19.62f, 20.21f, 19.0f, 18.67f, 19.0f)
                close()
            }
            materialPath {
                moveTo(8.68f, 17.5f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(0.82f, 0.0f, 1.17f, 0.46f, 1.93f, 0.76f)
                curveToRelative(0.66f, 0.26f, 1.38f, -0.23f, 1.38f, -0.94f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.42f, -0.26f, -0.79f, -0.65f, -0.94f)
                curveToRelative(-0.29f, -0.11f, -0.54f, -0.27f, -0.83f, -0.43f)
                lineToRelative(-2.02f, -7.53f)
                lineToRelative(1.17f, 0.47f)
                curveToRelative(0.51f, 0.21f, 1.09f, -0.04f, 1.29f, -0.55f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.21f, -0.51f, -0.05f, -1.1f, -0.57f, -1.29f)
                lineToRelative(-9.24f, -3.54f)
                curveToRelative(-0.81f, -0.31f, -1.72f, -0.06f, -2.27f, 0.61f)
                lineToRelative(-6.23f, 7.7f)
                curveToRelative(-0.35f, 0.43f, -0.28f, 1.06f, 0.16f, 1.4f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.43f, 0.34f, 1.06f, 0.26f, 1.39f, -0.17f)
                lineToRelative(0.78f, -1.0f)
                lineToRelative(0.93f, 3.48f)
                curveToRelative(-0.18f, -0.02f, -0.35f, -0.05f, -0.56f, -0.05f)
                curveToRelative(-1.54f, 0.0f, -1.95f, 0.62f, -2.66f, 0.88f)
                curveTo(2.27f, 15.53f, 2.0f, 15.91f, 2.0f, 16.33f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.7f, 0.69f, 1.19f, 1.35f, 0.95f)
                curveToRelative(0.8f, -0.29f, 1.18f, -0.78f, 2.0f, -0.78f)
                curveTo(6.54f, 16.5f, 6.77f, 17.5f, 8.68f, 17.5f)
                close()
                moveTo(14.04f, 10.18f)
                lineToRelative(1.42f, 5.31f)
                curveToRelative(-1.34f, 0.09f, -1.47f, -0.99f, -3.47f, -0.99f)
                curveToRelative(-0.36f, 0.0f, -0.65f, 0.04f, -0.91f, 0.1f)
                lineToRelative(-0.91f, -3.39f)
                lineTo(14.04f, 10.18f)
                close()
            }
        }
        return _flood!!
    }

private var _flood: ImageVector? = null
