/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Forward10: ImageVector
    get() {
        if (_forward10 != null) {
            return _forward10!!
        }
        _forward10 = materialIcon(name = "Rounded.Forward10") {
            materialPath {
                moveTo(18.92f, 13.0f)
                curveToRelative(-0.5f, 0.0f, -0.91f, 0.37f, -0.98f, 0.86f)
                curveToRelative(-0.48f, 3.37f, -3.77f, 5.84f, -7.42f, 4.96f)
                curveToRelative(-2.25f, -0.54f, -3.91f, -2.27f, -4.39f, -4.53f)
                curveTo(5.32f, 10.42f, 8.27f, 7.0f, 12.0f, 7.0f)
                verticalLineToRelative(2.79f)
                curveToRelative(0.0f, 0.45f, 0.54f, 0.67f, 0.85f, 0.35f)
                lineToRelative(3.79f, -3.79f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(-3.79f, -3.79f)
                curveToRelative(-0.31f, -0.31f, -0.85f, -0.09f, -0.85f, 0.36f)
                lineTo(12.0f, 5.0f)
                curveToRelative(-4.94f, 0.0f, -8.84f, 4.48f, -7.84f, 9.6f)
                curveToRelative(0.6f, 3.11f, 2.9f, 5.5f, 5.99f, 6.19f)
                curveToRelative(4.83f, 1.08f, 9.15f, -2.2f, 9.77f, -6.67f)
                curveToRelative(0.09f, -0.59f, -0.4f, -1.12f, -1.0f, -1.12f)
                close()
                moveTo(10.9f, 16.0f)
                verticalLineToRelative(-4.27f)
                horizontalLineToRelative(-0.09f)
                lineToRelative(-1.77f, 0.63f)
                verticalLineToRelative(0.69f)
                lineToRelative(1.01f, -0.31f)
                lineTo(10.05f, 16.0f)
                close()
                moveTo(14.32f, 11.78f)
                curveToRelative(-0.18f, -0.07f, -0.37f, -0.1f, -0.59f, -0.1f)
                reflectiveCurveToRelative(-0.41f, 0.03f, -0.59f, 0.1f)
                reflectiveCurveToRelative(-0.33f, 0.18f, -0.45f, 0.33f)
                reflectiveCurveToRelative(-0.23f, 0.34f, -0.29f, 0.57f)
                reflectiveCurveToRelative(-0.1f, 0.5f, -0.1f, 0.82f)
                verticalLineToRelative(0.74f)
                curveToRelative(0.0f, 0.32f, 0.04f, 0.6f, 0.11f, 0.82f)
                reflectiveCurveToRelative(0.17f, 0.42f, 0.3f, 0.57f)
                reflectiveCurveToRelative(0.28f, 0.26f, 0.46f, 0.33f)
                reflectiveCurveToRelative(0.37f, 0.1f, 0.59f, 0.1f)
                reflectiveCurveToRelative(0.41f, -0.03f, 0.59f, -0.1f)
                reflectiveCurveToRelative(0.33f, -0.18f, 0.45f, -0.33f)
                reflectiveCurveToRelative(0.22f, -0.34f, 0.29f, -0.57f)
                reflectiveCurveToRelative(0.1f, -0.5f, 0.1f, -0.82f)
                verticalLineToRelative(-0.74f)
                curveToRelative(0.0f, -0.32f, -0.04f, -0.6f, -0.11f, -0.82f)
                reflectiveCurveToRelative(-0.17f, -0.42f, -0.3f, -0.57f)
                reflectiveCurveToRelative(-0.29f, -0.26f, -0.46f, -0.33f)
                close()
                moveTo(14.33f, 14.35f)
                curveToRelative(0.0f, 0.19f, -0.01f, 0.35f, -0.04f, 0.48f)
                reflectiveCurveToRelative(-0.06f, 0.24f, -0.11f, 0.32f)
                reflectiveCurveToRelative(-0.11f, 0.14f, -0.19f, 0.17f)
                reflectiveCurveToRelative(-0.16f, 0.05f, -0.25f, 0.05f)
                reflectiveCurveToRelative(-0.18f, -0.02f, -0.25f, -0.05f)
                reflectiveCurveToRelative(-0.14f, -0.09f, -0.19f, -0.17f)
                reflectiveCurveToRelative(-0.09f, -0.19f, -0.12f, -0.32f)
                reflectiveCurveToRelative(-0.04f, -0.29f, -0.04f, -0.48f)
                verticalLineToRelative(-0.97f)
                curveToRelative(0.0f, -0.19f, 0.01f, -0.35f, 0.04f, -0.48f)
                reflectiveCurveToRelative(0.06f, -0.23f, 0.12f, -0.31f)
                reflectiveCurveToRelative(0.11f, -0.14f, 0.19f, -0.17f)
                reflectiveCurveToRelative(0.16f, -0.05f, 0.25f, -0.05f)
                reflectiveCurveToRelative(0.18f, 0.02f, 0.25f, 0.05f)
                reflectiveCurveToRelative(0.14f, 0.09f, 0.19f, 0.17f)
                reflectiveCurveToRelative(0.09f, 0.18f, 0.12f, 0.31f)
                reflectiveCurveToRelative(0.04f, 0.29f, 0.04f, 0.48f)
                verticalLineToRelative(0.97f)
                close()
            }
        }
        return _forward10!!
    }

private var _forward10: ImageVector? = null
