/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LegendToggle: ImageVector
    get() {
        if (_legendToggle != null) {
            return _legendToggle!!
        }
        _legendToggle = materialIcon(name = "Rounded.LegendToggle") {
            materialPath {
                moveTo(19.0f, 15.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(20.0f, 14.55f, 19.55f, 15.0f, 19.0f, 15.0f)
                close()
                moveTo(19.0f, 17.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(20.0f, 17.45f, 19.55f, 17.0f, 19.0f, 17.0f)
                close()
                moveTo(15.0f, 11.0f)
                lineToRelative(4.58f, -3.25f)
                curveTo(19.84f, 7.56f, 20.0f, 7.26f, 20.0f, 6.94f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.81f, -0.92f, -1.29f, -1.58f, -0.82f)
                lineTo(15.0f, 8.55f)
                lineTo(10.0f, 5.0f)
                lineTo(4.48f, 8.36f)
                curveTo(4.18f, 8.55f, 4.0f, 8.87f, 4.0f, 9.22f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.78f, 0.85f, 1.26f, 1.52f, 0.85f)
                lineToRelative(4.4f, -2.68f)
                lineTo(15.0f, 11.0f)
                close()
            }
        }
        return _legendToggle!!
    }

private var _legendToggle: ImageVector? = null
