/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Looks: ImageVector
    get() {
        if (_looks != null) {
            return _looks!!
        }
        _looks = materialIcon(name = "Rounded.Looks") {
            materialPath {
                moveTo(12.0f, 10.0f)
                curveToRelative(-3.47f, 0.0f, -6.36f, 2.54f, -6.91f, 5.86f)
                curveToRelative(-0.1f, 0.6f, 0.39f, 1.14f, 1.0f, 1.14f)
                curveToRelative(0.49f, 0.0f, 0.9f, -0.36f, 0.98f, -0.85f)
                curveTo(7.48f, 13.79f, 9.53f, 12.0f, 12.0f, 12.0f)
                reflectiveCurveToRelative(4.52f, 1.79f, 4.93f, 4.15f)
                curveToRelative(0.08f, 0.49f, 0.49f, 0.85f, 0.98f, 0.85f)
                curveToRelative(0.61f, 0.0f, 1.09f, -0.54f, 0.99f, -1.14f)
                curveTo(18.36f, 12.54f, 15.47f, 10.0f, 12.0f, 10.0f)
                close()
                moveTo(12.0f, 6.0f)
                curveTo(6.3f, 6.0f, 1.61f, 10.34f, 1.05f, 15.9f)
                curveToRelative(-0.05f, 0.59f, 0.41f, 1.1f, 1.01f, 1.1f)
                curveToRelative(0.51f, 0.0f, 0.94f, -0.38f, 0.99f, -0.88f)
                curveTo(3.49f, 11.57f, 7.34f, 8.0f, 12.0f, 8.0f)
                reflectiveCurveToRelative(8.51f, 3.57f, 8.96f, 8.12f)
                curveToRelative(0.05f, 0.5f, 0.48f, 0.88f, 0.99f, 0.88f)
                curveToRelative(0.59f, 0.0f, 1.06f, -0.51f, 1.0f, -1.1f)
                curveTo(22.39f, 10.34f, 17.7f, 6.0f, 12.0f, 6.0f)
                close()
            }
        }
        return _looks!!
    }

private var _looks: ImageVector? = null
