/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Microwave: ImageVector
    get() {
        if (_microwave != null) {
            return _microwave!!
        }
        _microwave = materialIcon(name = "Rounded.Microwave") {
            materialPath {
                moveTo(6.15f, 9.97f)
                lineTo(6.15f, 9.97f)
                curveTo(5.69f, 9.51f, 5.77f, 8.73f, 6.33f, 8.4f)
                curveTo(6.73f, 8.18f, 7.21f, 8.0f, 7.75f, 8.0f)
                curveToRelative(0.8f, 0.0f, 1.39f, 0.39f, 1.81f, 0.67f)
                curveTo(9.87f, 8.88f, 10.07f, 9.0f, 10.25f, 9.0f)
                curveToRelative(0.13f, 0.0f, 0.26f, -0.05f, 0.39f, -0.12f)
                curveToRelative(0.39f, -0.22f, 0.88f, -0.16f, 1.2f, 0.16f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.46f, 0.46f, 0.38f, 1.24f, -0.18f, 1.56f)
                curveToRelative(-0.39f, 0.23f, -0.87f, 0.4f, -1.41f, 0.4f)
                curveToRelative(-0.79f, 0.0f, -1.37f, -0.38f, -1.79f, -0.66f)
                curveTo(8.13f, 10.12f, 7.94f, 10.0f, 7.75f, 10.0f)
                curveToRelative(-0.13f, 0.0f, -0.26f, 0.05f, -0.39f, 0.12f)
                curveTo(6.96f, 10.35f, 6.47f, 10.28f, 6.15f, 9.97f)
                close()
                moveTo(7.75f, 15.0f)
                curveToRelative(0.19f, 0.0f, 0.38f, 0.12f, 0.71f, 0.34f)
                curveToRelative(0.42f, 0.28f, 1.0f, 0.66f, 1.79f, 0.66f)
                curveToRelative(0.54f, 0.0f, 1.02f, -0.17f, 1.41f, -0.4f)
                curveToRelative(0.56f, -0.32f, 0.64f, -1.1f, 0.18f, -1.56f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.32f, -0.32f, -0.81f, -0.38f, -1.2f, -0.16f)
                curveTo(10.51f, 13.95f, 10.38f, 14.0f, 10.25f, 14.0f)
                curveToRelative(-0.18f, 0.0f, -0.38f, -0.12f, -0.69f, -0.33f)
                curveTo(9.14f, 13.39f, 8.55f, 13.0f, 7.75f, 13.0f)
                curveToRelative(-0.54f, 0.0f, -1.02f, 0.18f, -1.42f, 0.4f)
                curveToRelative(-0.56f, 0.33f, -0.64f, 1.11f, -0.18f, 1.56f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.32f, 0.32f, 0.81f, 0.38f, 1.2f, 0.16f)
                curveTo(7.49f, 15.05f, 7.62f, 15.0f, 7.75f, 15.0f)
                close()
                moveTo(22.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(16.0f)
                curveTo(21.1f, 4.0f, 22.0f, 4.9f, 22.0f, 6.0f)
                close()
                moveTo(14.0f, 6.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(19.0f, 16.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveTo(18.55f, 17.0f, 19.0f, 16.55f, 19.0f, 16.0f)
                close()
                moveTo(19.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveTo(18.55f, 13.0f, 19.0f, 12.55f, 19.0f, 12.0f)
                close()
                moveTo(19.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                close()
            }
        }
        return _microwave!!
    }

private var _microwave: ImageVector? = null
