/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Nightlight: ImageVector
    get() {
        if (_nightlight != null) {
            return _nightlight!!
        }
        _nightlight = materialIcon(name = "Rounded.Nightlight") {
            materialPath {
                moveTo(11.57f, 2.3f)
                curveToRelative(2.38f, -0.59f, 4.68f, -0.27f, 6.63f, 0.64f)
                curveToRelative(0.35f, 0.16f, 0.41f, 0.64f, 0.1f, 0.86f)
                curveTo(15.7f, 5.6f, 14.0f, 8.6f, 14.0f, 12.0f)
                reflectiveCurveToRelative(1.7f, 6.4f, 4.3f, 8.2f)
                curveToRelative(0.32f, 0.22f, 0.26f, 0.7f, -0.09f, 0.86f)
                curveTo(16.93f, 21.66f, 15.5f, 22.0f, 14.0f, 22.0f)
                curveToRelative(-6.05f, 0.0f, -10.85f, -5.38f, -9.87f, -11.6f)
                curveTo(4.74f, 6.48f, 7.72f, 3.24f, 11.57f, 2.3f)
                close()
            }
        }
        return _nightlight!!
    }

private var _nightlight: ImageVector? = null
