/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NotStarted: ImageVector
    get() {
        if (_notStarted != null) {
            return _notStarted!!
        }
        _notStarted = materialIcon(name = "Rounded.NotStarted") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(11.0f, 15.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(15.0f)
                close()
                moveTo(16.02f, 12.78f)
                lineToRelative(-2.4f, 1.92f)
                curveTo(12.97f, 15.22f, 12.0f, 14.76f, 12.0f, 13.92f)
                verticalLineToRelative(-3.84f)
                curveToRelative(0.0f, -0.84f, 0.97f, -1.3f, 1.62f, -0.78f)
                lineToRelative(2.4f, 1.92f)
                curveTo(16.52f, 11.62f, 16.52f, 12.38f, 16.02f, 12.78f)
                close()
            }
        }
        return _notStarted!!
    }

private var _notStarted: ImageVector? = null
