/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SavedSearch: ImageVector
    get() {
        if (_savedSearch != null) {
            return _savedSearch!!
        }
        _savedSearch = materialIcon(name = "Rounded.SavedSearch") {
            materialPath {
                moveTo(14.73f, 13.31f)
                curveToRelative(1.13f, -1.55f, 1.63f, -3.58f, 0.98f, -5.74f)
                curveToRelative(-0.68f, -2.23f, -2.57f, -3.98f, -4.85f, -4.44f)
                curveTo(6.21f, 2.2f, 2.2f, 6.22f, 3.14f, 10.86f)
                curveToRelative(0.46f, 2.29f, 2.21f, 4.18f, 4.44f, 4.85f)
                curveToRelative(2.16f, 0.65f, 4.19f, 0.15f, 5.74f, -0.98f)
                lineToRelative(5.56f, 5.56f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(14.73f, 13.31f)
                close()
                moveTo(9.5f, 14.0f)
                curveTo(7.01f, 14.0f, 5.0f, 11.99f, 5.0f, 9.5f)
                reflectiveCurveTo(7.01f, 5.0f, 9.5f, 5.0f)
                reflectiveCurveTo(14.0f, 7.01f, 14.0f, 9.5f)
                reflectiveCurveTo(11.99f, 14.0f, 9.5f, 14.0f)
                close()
            }
            materialPath {
                moveTo(10.29f, 8.44f)
                lineToRelative(-0.79f, -2.44f)
                lineToRelative(-0.79f, 2.44f)
                lineToRelative(-2.46f, 0.0f)
                lineToRelative(2.01f, 1.59f)
                lineToRelative(-0.77f, 2.47f)
                lineToRelative(2.01f, -1.53f)
                lineToRelative(2.01f, 1.53f)
                lineToRelative(-0.77f, -2.47f)
                lineToRelative(2.01f, -1.59f)
                close()
            }
        }
        return _savedSearch!!
    }

private var _savedSearch: ImageVector? = null
