/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ScreenRotationAlt: ImageVector
    get() {
        if (_screenRotationAlt != null) {
            return _screenRotationAlt!!
        }
        _screenRotationAlt = materialIcon(name = "Rounded.ScreenRotationAlt") {
            materialPath {
                moveTo(18.53f, 9.29f)
                curveTo(19.16f, 9.92f, 18.71f, 11.0f, 17.82f, 11.0f)
                curveToRelative(-0.27f, 0.0f, -0.52f, -0.11f, -0.71f, -0.29f)
                lineTo(10.4f, 4.0f)
                lineTo(5.41f, 9.0f)
                horizontalLineTo(7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.59f)
                lineToRelative(5.0f, -5.0f)
                curveToRelative(0.78f, -0.78f, 2.05f, -0.78f, 2.83f, 0.0f)
                lineTo(18.53f, 9.29f)
                close()
            }
            materialPath {
                moveTo(5.47f, 14.71f)
                curveTo(4.84f, 14.08f, 5.29f, 13.0f, 6.18f, 13.0f)
                curveToRelative(0.27f, 0.0f, 0.52f, 0.11f, 0.71f, 0.29f)
                lineTo(13.6f, 20.0f)
                lineToRelative(4.99f, -5.0f)
                horizontalLineTo(17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-1.59f)
                lineToRelative(-5.0f, 5.0f)
                curveToRelative(-0.78f, 0.78f, -2.05f, 0.78f, -2.83f, 0.0f)
                lineTo(5.47f, 14.71f)
                close()
            }
        }
        return _screenRotationAlt!!
    }

private var _screenRotationAlt: ImageVector? = null
