/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SettingsInputHdmi: ImageVector
    get() {
        if (_settingsInputHdmi != null) {
            return _settingsInputHdmi!!
        }
        _settingsInputHdmi = materialIcon(name = "Rounded.SettingsInputHdmi") {
            materialPath {
                moveTo(18.0f, 7.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 2.0f, 6.0f, 2.9f, 6.0f, 4.0f)
                verticalLineToRelative(3.0f)
                curveTo(5.45f, 7.0f, 5.0f, 7.45f, 5.0f, 8.0f)
                verticalLineToRelative(4.7f)
                curveToRelative(0.0f, 0.2f, 0.06f, 0.39f, 0.17f, 0.55f)
                lineTo(8.0f, 19.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(2.83f, -5.75f)
                curveTo(18.94f, 13.09f, 19.0f, 12.89f, 19.0f, 12.7f)
                verticalLineTo(8.0f)
                curveTo(19.0f, 7.45f, 18.55f, 7.0f, 18.0f, 7.0f)
                close()
                moveTo(16.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.5f)
                curveTo(14.0f, 5.22f, 13.78f, 5.0f, 13.5f, 5.0f)
                reflectiveCurveTo(13.0f, 5.22f, 13.0f, 5.5f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.5f)
                curveTo(11.0f, 5.22f, 10.78f, 5.0f, 10.5f, 5.0f)
                reflectiveCurveTo(10.0f, 5.22f, 10.0f, 5.5f)
                verticalLineTo(7.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(7.0f)
                close()
            }
        }
        return _settingsInputHdmi!!
    }

private var _settingsInputHdmi: ImageVector? = null
