/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SettingsSuggest: ImageVector
    get() {
        if (_settingsSuggest != null) {
            return _settingsSuggest!!
        }
        _settingsSuggest = materialIcon(name = "Rounded.SettingsSuggest") {
            materialPath {
                moveTo(18.04f, 7.99f)
                lineToRelative(-0.63f, -1.4f)
                lineToRelative(-1.4f, -0.63f)
                curveToRelative(-0.39f, -0.18f, -0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(1.4f, -0.63f)
                lineToRelative(0.63f, -1.4f)
                curveToRelative(0.18f, -0.39f, 0.73f, -0.39f, 0.91f, 0.0f)
                lineToRelative(0.63f, 1.4f)
                lineToRelative(1.4f, 0.63f)
                curveToRelative(0.39f, 0.18f, 0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(-1.4f, 0.63f)
                lineToRelative(-0.63f, 1.4f)
                curveTo(18.78f, 8.38f, 18.22f, 8.38f, 18.04f, 7.99f)
                close()
                moveTo(21.28f, 12.72f)
                lineTo(20.96f, 12.0f)
                curveToRelative(-0.18f, -0.39f, -0.73f, -0.39f, -0.91f, 0.0f)
                lineToRelative(-0.32f, 0.72f)
                lineTo(19.0f, 13.04f)
                curveToRelative(-0.39f, 0.18f, -0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(0.72f, 0.32f)
                lineTo(20.04f, 15.0f)
                curveToRelative(0.18f, 0.39f, 0.73f, 0.39f, 0.91f, 0.0f)
                lineToRelative(0.32f, -0.72f)
                lineTo(22.0f, 13.96f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineTo(21.28f, 12.72f)
                close()
                moveTo(16.24f, 14.37f)
                lineToRelative(1.23f, 0.93f)
                curveToRelative(0.4f, 0.3f, 0.51f, 0.86f, 0.26f, 1.3f)
                lineToRelative(-1.62f, 2.8f)
                curveToRelative(-0.25f, 0.44f, -0.79f, 0.62f, -1.25f, 0.42f)
                lineToRelative(-1.43f, -0.6f)
                curveToRelative(-0.2f, 0.13f, -0.42f, 0.26f, -0.64f, 0.37f)
                lineToRelative(-0.19f, 1.54f)
                curveToRelative(-0.06f, 0.5f, -0.49f, 0.88f, -0.99f, 0.88f)
                horizontalLineTo(8.38f)
                curveToRelative(-0.5f, 0.0f, -0.93f, -0.38f, -0.99f, -0.88f)
                lineTo(7.2f, 19.59f)
                curveToRelative(-0.22f, -0.11f, -0.43f, -0.23f, -0.64f, -0.37f)
                lineToRelative(-1.43f, 0.6f)
                curveToRelative(-0.46f, 0.2f, -1.0f, 0.02f, -1.25f, -0.42f)
                lineToRelative(-1.62f, -2.8f)
                curveToRelative(-0.25f, -0.44f, -0.14f, -0.99f, 0.26f, -1.3f)
                lineToRelative(1.23f, -0.93f)
                curveTo(3.75f, 14.25f, 3.75f, 14.12f, 3.75f, 14.0f)
                reflectiveCurveToRelative(0.0f, -0.25f, 0.01f, -0.37f)
                lineTo(2.53f, 12.7f)
                curveToRelative(-0.4f, -0.3f, -0.51f, -0.86f, -0.26f, -1.3f)
                lineToRelative(1.62f, -2.8f)
                curveToRelative(0.25f, -0.44f, 0.79f, -0.62f, 1.25f, -0.42f)
                lineToRelative(1.43f, 0.6f)
                curveToRelative(0.2f, -0.13f, 0.42f, -0.26f, 0.64f, -0.37f)
                lineToRelative(0.19f, -1.54f)
                curveTo(7.45f, 6.38f, 7.88f, 6.0f, 8.38f, 6.0f)
                horizontalLineToRelative(3.23f)
                curveToRelative(0.5f, 0.0f, 0.93f, 0.38f, 0.99f, 0.88f)
                lineToRelative(0.19f, 1.54f)
                curveToRelative(0.22f, 0.11f, 0.43f, 0.23f, 0.64f, 0.37f)
                lineToRelative(1.43f, -0.6f)
                curveToRelative(0.46f, -0.2f, 1.0f, -0.02f, 1.25f, 0.42f)
                lineToRelative(1.62f, 2.8f)
                curveToRelative(0.25f, 0.44f, 0.14f, 0.99f, -0.26f, 1.3f)
                lineToRelative(-1.23f, 0.93f)
                curveToRelative(0.01f, 0.12f, 0.01f, 0.24f, 0.01f, 0.37f)
                reflectiveCurveTo(16.25f, 14.25f, 16.24f, 14.37f)
                close()
                moveTo(13.0f, 14.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveTo(13.0f, 15.66f, 13.0f, 14.0f)
                close()
            }
        }
        return _settingsSuggest!!
    }

private var _settingsSuggest: ImageVector? = null
