/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SsidChart: ImageVector
    get() {
        if (_ssidChart != null) {
            return _ssidChart!!
        }
        _ssidChart = materialIcon(name = "Rounded.SsidChart") {
            materialPath {
                moveTo(3.0f, 9.03f)
                curveToRelative(0.0f, -0.32f, 0.15f, -0.62f, 0.41f, -0.81f)
                lineTo(7.14f, 5.5f)
                curveToRelative(0.4f, -0.29f, 0.95f, -0.25f, 1.3f, 0.1f)
                lineToRelative(3.78f, 3.78f)
                lineToRelative(7.2f, -5.23f)
                curveTo(20.07f, 3.67f, 21.0f, 4.14f, 21.0f, 4.96f)
                curveToRelative(0.0f, 0.32f, -0.15f, 0.62f, -0.41f, 0.81f)
                lineToRelative(-7.9f, 5.73f)
                curveToRelative(-0.4f, 0.29f, -0.95f, 0.25f, -1.29f, -0.1f)
                lineTo(7.62f, 7.62f)
                lineTo(4.59f, 9.84f)
                curveTo(3.93f, 10.32f, 3.0f, 9.85f, 3.0f, 9.03f)
                close()
                moveTo(21.0f, 16.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.35f)
                curveToRelative(-0.23f, 0.0f, -0.45f, 0.08f, -0.62f, 0.22f)
                lineToRelative(-3.9f, 3.12f)
                lineTo(6.6f, 12.99f)
                curveToRelative(-0.35f, -0.34f, -0.88f, -0.38f, -1.27f, -0.1f)
                lineToRelative(-1.9f, 1.35f)
                curveTo(3.16f, 14.43f, 3.0f, 14.74f, 3.0f, 15.06f)
                curveToRelative(0.0f, 0.81f, 0.92f, 1.29f, 1.58f, 0.81f)
                lineTo(5.8f, 15.0f)
                lineToRelative(5.57f, 5.39f)
                curveToRelative(0.36f, 0.35f, 0.93f, 0.38f, 1.32f, 0.06f)
                lineTo(17.0f, 17.0f)
                horizontalLineToRelative(3.0f)
                curveTo(20.55f, 17.0f, 21.0f, 16.55f, 21.0f, 16.0f)
                close()
            }
        }
        return _ssidChart!!
    }

private var _ssidChart: ImageVector? = null
