/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Stream: ImageVector
    get() {
        if (_stream != null) {
            return _stream!!
        }
        _stream = materialIcon(name = "Rounded.Stream") {
            materialPath {
                moveTo(20.0f, 12.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(4.0f, 12.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 20.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(7.89f, 14.65f)
                lineToRelative(-2.94f, 2.93f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                reflectiveCurveToRelative(1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(2.94f, -2.93f)
                curveToRelative(0.39f, -0.38f, 0.39f, -1.02f, 0.0f, -1.41f)
                curveTo(8.91f, 14.26f, 8.28f, 14.26f, 7.89f, 14.65f)
                close()
            }
            materialPath {
                moveTo(6.41f, 4.94f)
                curveTo(6.02f, 4.55f, 5.39f, 4.55f, 5.0f, 4.94f)
                curveTo(4.61f, 5.33f, 4.61f, 5.96f, 5.0f, 6.35f)
                lineToRelative(2.93f, 2.94f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.42f, 0.0f)
                curveTo(9.73f, 8.9f, 9.73f, 8.27f, 9.34f, 7.88f)
                lineTo(6.41f, 4.94f)
                close()
            }
            materialPath {
                moveTo(16.12f, 14.65f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.42f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(17.64f, 19.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                reflectiveCurveToRelative(0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(16.12f, 14.65f)
                close()
            }
            materialPath {
                moveTo(16.06f, 9.33f)
                lineToRelative(2.99f, -2.98f)
                curveToRelative(0.39f, -0.4f, 0.39f, -1.03f, 0.0f, -1.42f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-2.99f, 2.98f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.42f)
                curveTo(15.04f, 9.72f, 15.67f, 9.72f, 16.06f, 9.33f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _stream!!
    }

private var _stream: ImageVector? = null
