/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Swipe: ImageVector
    get() {
        if (_swipe != null) {
            return _swipe!!
        }
        _swipe = materialIcon(name = "Rounded.Swipe") {
            materialPath {
                moveTo(21.15f, 2.85f)
                lineToRelative(-1.02f, 1.02f)
                curveTo(18.69f, 2.17f, 15.6f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(5.31f, 2.17f, 3.87f, 3.87f)
                lineTo(2.85f, 2.85f)
                curveTo(2.54f, 2.54f, 2.0f, 2.76f, 2.0f, 3.21f)
                verticalLineTo(6.5f)
                curveTo(2.0f, 6.78f, 2.22f, 7.0f, 2.5f, 7.0f)
                horizontalLineToRelative(3.29f)
                curveToRelative(0.45f, 0.0f, 0.67f, -0.54f, 0.35f, -0.85f)
                lineTo(4.93f, 4.93f)
                curveToRelative(1.0f, -1.29f, 3.7f, -2.43f, 7.07f, -2.43f)
                reflectiveCurveToRelative(6.07f, 1.14f, 7.07f, 2.43f)
                lineToRelative(-1.22f, 1.22f)
                curveTo(17.54f, 6.46f, 17.76f, 7.0f, 18.21f, 7.0f)
                horizontalLineToRelative(3.29f)
                curveTo(21.78f, 7.0f, 22.0f, 6.78f, 22.0f, 6.5f)
                verticalLineTo(3.21f)
                curveTo(22.0f, 2.76f, 21.46f, 2.54f, 21.15f, 2.85f)
                close()
            }
            materialPath {
                moveTo(14.5f, 12.71f)
                curveToRelative(-0.28f, -0.14f, -0.58f, -0.21f, -0.89f, -0.21f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(-6.0f)
                curveTo(13.0f, 5.67f, 12.33f, 5.0f, 11.5f, 5.0f)
                reflectiveCurveTo(10.0f, 5.67f, 10.0f, 6.5f)
                verticalLineToRelative(10.74f)
                lineToRelative(-3.44f, -0.72f)
                curveToRelative(-0.37f, -0.08f, -0.76f, 0.04f, -1.03f, 0.31f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.43f, 0.44f, -0.43f, 1.14f, 0.01f, 1.58f)
                lineToRelative(4.01f, 4.01f)
                curveTo(9.92f, 22.79f, 10.43f, 23.0f, 10.96f, 23.0f)
                horizontalLineToRelative(6.41f)
                curveToRelative(1.0f, 0.0f, 1.84f, -0.73f, 1.98f, -1.72f)
                lineToRelative(0.63f, -4.46f)
                curveToRelative(0.12f, -0.85f, -0.32f, -1.69f, -1.09f, -2.07f)
                lineTo(14.5f, 12.71f)
                close()
            }
        }
        return _swipe!!
    }

private var _swipe: ImageVector? = null
