/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SyncAlt: ImageVector
    get() {
        if (_syncAlt != null) {
            return _syncAlt!!
        }
        _syncAlt = materialIcon(name = "Rounded.SyncAlt") {
            materialPath {
                moveTo(21.65f, 7.65f)
                lineToRelative(-2.79f, -2.79f)
                curveTo(18.54f, 4.54f, 18.0f, 4.76f, 18.0f, 5.21f)
                verticalLineTo(7.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 7.0f, 3.0f, 7.45f, 3.0f, 8.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(1.79f)
                curveToRelative(0.0f, 0.45f, 0.54f, 0.67f, 0.85f, 0.35f)
                lineToRelative(2.79f, -2.79f)
                curveTo(21.84f, 8.16f, 21.84f, 7.84f, 21.65f, 7.65f)
                close()
            }
            materialPath {
                moveTo(20.0f, 15.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-1.79f)
                curveToRelative(0.0f, -0.45f, -0.54f, -0.67f, -0.85f, -0.35f)
                lineToRelative(-2.79f, 2.79f)
                curveToRelative(-0.2f, 0.19f, -0.2f, 0.51f, -0.01f, 0.7f)
                lineToRelative(2.79f, 2.79f)
                curveTo(5.46f, 19.46f, 6.0f, 19.24f, 6.0f, 18.79f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveTo(20.55f, 15.0f, 20.0f, 15.0f)
                close()
            }
        }
        return _syncAlt!!
    }

private var _syncAlt: ImageVector? = null
