/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Thunderstorm: ImageVector
    get() {
        if (_thunderstorm != null) {
            return _thunderstorm!!
        }
        _thunderstorm = materialIcon(name = "Rounded.Thunderstorm") {
            materialPath {
                moveTo(17.92f, 7.02f)
                curveTo(17.45f, 4.18f, 14.97f, 2.0f, 12.0f, 2.0f)
                curveTo(9.82f, 2.0f, 7.83f, 3.18f, 6.78f, 5.06f)
                curveTo(4.09f, 5.41f, 2.0f, 7.74f, 2.0f, 10.5f)
                curveTo(2.0f, 13.53f, 4.47f, 16.0f, 7.5f, 16.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(2.48f, 0.0f, 4.5f, -2.02f, 4.5f, -4.5f)
                curveTo(22.0f, 9.16f, 20.21f, 7.23f, 17.92f, 7.02f)
                close()
            }
            materialPath {
                moveTo(15.95f, 20.11f)
                lineToRelative(-0.84f, -0.42f)
                lineToRelative(0.9f, -1.03f)
                curveToRelative(0.36f, -0.42f, 0.32f, -1.05f, -0.09f, -1.41f)
                curveToRelative(-0.42f, -0.36f, -1.05f, -0.32f, -1.41f, 0.09f)
                lineToRelative(-1.75f, 2.0f)
                curveToRelative(-0.2f, 0.23f, -0.29f, 0.55f, -0.23f, 0.85f)
                curveToRelative(0.06f, 0.3f, 0.26f, 0.56f, 0.53f, 0.7f)
                lineToRelative(0.84f, 0.42f)
                lineTo(13.0f, 22.34f)
                curveToRelative(-0.36f, 0.42f, -0.32f, 1.05f, 0.09f, 1.41f)
                curveToRelative(0.19f, 0.17f, 0.42f, 0.25f, 0.66f, 0.25f)
                curveToRelative(0.28f, 0.0f, 0.55f, -0.12f, 0.75f, -0.34f)
                lineToRelative(1.75f, -2.0f)
                curveToRelative(0.2f, -0.23f, 0.29f, -0.55f, 0.23f, -0.85f)
                curveTo(16.42f, 20.5f, 16.22f, 20.24f, 15.95f, 20.11f)
                close()
            }
            materialPath {
                moveTo(9.95f, 20.11f)
                lineTo(9.1f, 19.68f)
                lineToRelative(0.9f, -1.03f)
                curveToRelative(0.36f, -0.42f, 0.32f, -1.05f, -0.09f, -1.41f)
                curveToRelative(-0.42f, -0.36f, -1.05f, -0.32f, -1.41f, 0.09f)
                lineToRelative(-1.75f, 2.0f)
                curveToRelative(-0.2f, 0.23f, -0.29f, 0.55f, -0.23f, 0.85f)
                curveToRelative(0.06f, 0.3f, 0.26f, 0.56f, 0.53f, 0.7f)
                lineToRelative(0.84f, 0.42f)
                lineTo(7.0f, 22.34f)
                curveToRelative(-0.36f, 0.42f, -0.32f, 1.05f, 0.09f, 1.41f)
                curveTo(7.28f, 23.92f, 7.52f, 24.0f, 7.75f, 24.0f)
                curveToRelative(0.28f, 0.0f, 0.55f, -0.12f, 0.75f, -0.34f)
                lineToRelative(1.75f, -2.0f)
                curveToRelative(0.2f, -0.23f, 0.29f, -0.55f, 0.23f, -0.85f)
                curveTo(10.42f, 20.5f, 10.22f, 20.24f, 9.95f, 20.11f)
                close()
            }
        }
        return _thunderstorm!!
    }

private var _thunderstorm: ImageVector? = null
