/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Yard: ImageVector
    get() {
        if (_yard != null) {
            return _yard!!
        }
        _yard = materialIcon(name = "Rounded.Yard") {
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(8.0f, 8.22f)
                curveToRelative(0.0f, -0.86f, 0.7f, -1.56f, 1.56f, -1.56f)
                curveToRelative(0.33f, 0.0f, 0.64f, 0.1f, 0.89f, 0.28f)
                lineToRelative(-0.01f, -0.12f)
                curveToRelative(0.0f, -0.86f, 0.7f, -1.56f, 1.56f, -1.56f)
                reflectiveCurveToRelative(1.56f, 0.7f, 1.56f, 1.56f)
                lineToRelative(-0.01f, 0.12f)
                curveToRelative(0.26f, -0.18f, 0.56f, -0.28f, 0.89f, -0.28f)
                curveToRelative(0.86f, 0.0f, 1.56f, 0.7f, 1.56f, 1.56f)
                curveToRelative(0.0f, 0.62f, -0.37f, 1.16f, -0.89f, 1.4f)
                curveTo(15.63f, 9.87f, 16.0f, 10.41f, 16.0f, 11.03f)
                curveToRelative(0.0f, 0.86f, -0.7f, 1.56f, -1.56f, 1.56f)
                curveToRelative(-0.33f, 0.0f, -0.64f, -0.11f, -0.89f, -0.28f)
                lineToRelative(0.01f, 0.12f)
                curveToRelative(0.0f, 0.86f, -0.7f, 1.56f, -1.56f, 1.56f)
                reflectiveCurveToRelative(-1.56f, -0.7f, -1.56f, -1.56f)
                lineToRelative(0.01f, -0.12f)
                curveToRelative(-0.26f, 0.18f, -0.56f, 0.28f, -0.89f, 0.28f)
                curveTo(8.7f, 12.59f, 8.0f, 11.89f, 8.0f, 11.03f)
                curveToRelative(0.0f, -0.62f, 0.37f, -1.16f, 0.89f, -1.4f)
                curveTo(8.37f, 9.38f, 8.0f, 8.84f, 8.0f, 8.22f)
                close()
                moveTo(12.0f, 19.0f)
                curveToRelative(-2.83f, 0.0f, -5.21f, -1.97f, -5.84f, -4.61f)
                curveToRelative(-0.18f, -0.74f, 0.49f, -1.4f, 1.23f, -1.23f)
                curveTo(10.03f, 13.79f, 12.0f, 16.17f, 12.0f, 19.0f)
                curveToRelative(0.0f, -2.83f, 1.97f, -5.21f, 4.61f, -5.84f)
                curveToRelative(0.74f, -0.18f, 1.4f, 0.49f, 1.23f, 1.23f)
                curveTo(17.21f, 17.03f, 14.83f, 19.0f, 12.0f, 19.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 9.62f)
                moveToRelative(-1.56f, 0.0f)
                arcToRelative(1.56f, 1.56f, 0.0f, true, true, 3.12f, 0.0f)
                arcToRelative(1.56f, 1.56f, 0.0f, true, true, -3.12f, 0.0f)
            }
        }
        return _yard!!
    }

private var _yard: ImageVector? = null
