/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ConnectedTv: ImageVector
    get() {
        if (_connectedTv != null) {
            return _connectedTv!!
        }
        _connectedTv = materialIcon(name = "Sharp.ConnectedTv") {
            materialPath {
                moveTo(8.57f, 16.0f)
                horizontalLineTo(10.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                verticalLineToRelative(1.43f)
                curveTo(6.97f, 12.43f, 8.57f, 14.03f, 8.57f, 16.0f)
                close()
            }
            materialPath {
                moveTo(11.55f, 16.0f)
                horizontalLineTo(13.0f)
                curveToRelative(0.0f, -4.42f, -3.59f, -8.0f, -8.0f, -8.0f)
                verticalLineToRelative(1.45f)
                curveTo(8.61f, 9.45f, 11.55f, 12.38f, 11.55f, 16.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 14.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                curveTo(7.0f, 14.89f, 6.11f, 14.0f, 5.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 3.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(3.0f)
                close()
                moveTo(20.0f, 17.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _connectedTv!!
    }

private var _connectedTv: ImageVector? = null
