/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ContactEmergency: ImageVector
    get() {
        if (_contactEmergency != null) {
            return _contactEmergency!!
        }
        _contactEmergency = materialIcon(name = "Sharp.ContactEmergency") {
            materialPath {
                moveTo(23.99f, 3.0f)
                horizontalLineTo(0.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(23.99f)
                verticalLineTo(3.0f)
                close()
                moveTo(9.0f, 8.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, 1.35f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.35f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveToRelative(-3.0f, -1.35f, -3.0f, -3.0f)
                reflectiveCurveTo(7.35f, 8.0f, 9.0f, 8.0f)
                close()
                moveTo(2.08f, 19.0f)
                curveToRelative(1.38f, -2.39f, 3.96f, -4.0f, 6.92f, -4.0f)
                reflectiveCurveToRelative(5.54f, 1.61f, 6.92f, 4.0f)
                horizontalLineTo(2.08f)
                close()
                moveTo(20.97f, 9.85f)
                lineToRelative(-0.75f, 1.3f)
                lineToRelative(-1.47f, -0.85f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-1.7f)
                lineToRelative(-1.47f, 0.85f)
                lineToRelative(-0.75f, -1.3f)
                lineTo(16.5f, 9.0f)
                lineToRelative(-1.47f, -0.85f)
                lineToRelative(0.75f, -1.3f)
                lineToRelative(1.47f, 0.85f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(1.7f)
                lineToRelative(1.47f, -0.85f)
                lineToRelative(0.75f, 1.3f)
                lineTo(19.5f, 9.0f)
                lineTo(20.97f, 9.85f)
                close()
            }
        }
        return _contactEmergency!!
    }

private var _contactEmergency: ImageVector? = null
