/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FiberDvr: ImageVector
    get() {
        if (_fiberDvr != null) {
            return _fiberDvr!!
        }
        _fiberDvr = materialIcon(name = "Sharp.FiberDvr") {
            materialPath {
                moveTo(17.5f, 10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                close()
                moveTo(4.5f, 10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                close()
                moveTo(23.0f, 3.0f)
                lineTo(1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(22.0f)
                lineTo(23.0f, 3.0f)
                close()
                moveTo(8.0f, 13.5f)
                curveToRelative(0.0f, 0.85f, -0.65f, 1.5f, -1.5f, 1.5f)
                lineTo(3.0f, 15.0f)
                lineTo(3.0f, 9.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.85f, 0.0f, 1.5f, 0.65f, 1.5f, 1.5f)
                verticalLineToRelative(3.0f)
                close()
                moveTo(12.62f, 15.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(9.37f, 9.0f)
                horizontalLineToRelative(1.5f)
                lineToRelative(1.0f, 3.43f)
                lineToRelative(1.0f, -3.43f)
                horizontalLineToRelative(1.5f)
                lineToRelative(-1.75f, 6.0f)
                close()
                moveTo(21.0f, 12.9f)
                horizontalLineToRelative(-0.9f)
                lineTo(21.0f, 15.0f)
                horizontalLineToRelative(-1.5f)
                lineToRelative(-0.85f, -2.0f)
                lineTo(17.5f, 13.0f)
                verticalLineToRelative(2.0f)
                lineTo(16.0f, 15.0f)
                lineTo(16.0f, 9.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(3.9f)
                close()
            }
        }
        return _fiberDvr!!
    }

private var _fiberDvr: ImageVector? = null
