/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Hive: ImageVector
    get() {
        if (_hive != null) {
            return _hive!!
        }
        _hive = materialIcon(name = "Sharp.Hive") {
            materialPath {
                moveTo(13.79f, 8.0f)
                lineToRelative(1.8f, -3.0f)
                lineToRelative(-1.8f, -3.0f)
                lineToRelative(-3.58f, 0.0f)
                lineToRelative(-1.8f, 3.0f)
                lineToRelative(1.8f, 3.0f)
                close()
            }
            materialPath {
                moveTo(10.21f, 9.0f)
                lineToRelative(-1.8f, 3.0f)
                lineToRelative(1.8f, 3.0f)
                lineToRelative(3.58f, 0.0f)
                lineToRelative(1.8f, -3.0f)
                lineToRelative(-1.8f, -3.0f)
                close()
            }
            materialPath {
                moveTo(16.45f, 11.51f)
                lineToRelative(3.59f, 0.0f)
                lineToRelative(1.79f, -3.0f)
                lineToRelative(-1.79f, -3.0f)
                lineToRelative(-3.59f, 0.0f)
                lineToRelative(-1.8f, 3.0f)
                close()
            }
            materialPath {
                moveTo(20.04f, 12.51f)
                lineToRelative(-3.59f, 0.0f)
                lineToRelative(-1.8f, 3.0f)
                lineToRelative(1.8f, 3.0f)
                lineToRelative(3.59f, 0.0f)
                lineToRelative(1.79f, -3.0f)
                close()
            }
            materialPath {
                moveTo(7.55f, 11.51f)
                lineToRelative(1.8f, -3.0f)
                lineToRelative(-1.8f, -3.0f)
                lineToRelative(-3.59f, 0.0f)
                lineToRelative(-1.79f, 3.0f)
                lineToRelative(1.79f, 3.0f)
                close()
            }
            materialPath {
                moveTo(7.55f, 12.51f)
                lineToRelative(-3.59f, 0.0f)
                lineToRelative(-1.79f, 3.0f)
                lineToRelative(1.79f, 3.0f)
                lineToRelative(3.59f, 0.0f)
                lineToRelative(1.8f, -3.0f)
                close()
            }
            materialPath {
                moveTo(10.21f, 16.0f)
                lineToRelative(-1.8f, 3.0f)
                lineToRelative(1.8f, 3.0f)
                lineToRelative(3.58f, 0.0f)
                lineToRelative(1.8f, -3.0f)
                lineToRelative(-1.8f, -3.0f)
                close()
            }
        }
        return _hive!!
    }

private var _hive: ImageVector? = null
